/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import noppes.npcs.CustomRegisters;
import noppes.npcs.LogWriter;
import noppes.npcs.api.ICustomElement;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.blocks.CustomBlock;
import noppes.npcs.constants.CustomBlockTypes;
import noppes.npcs.items.CustomItem;
import noppes.npcs.util.Util;

public abstract class CustomBlockSlab
extends BlockSlab
implements ICustomElement {
    public static final PropertyEnum<CustomBlockTypes.TreeType> VARIANT = PropertyEnum.func_177709_a((String)"type", CustomBlockTypes.TreeType.class);
    protected NBTTagCompound nbtData;

    public CustomBlockSlab(NBTTagCompound nbtBlock) {
        super(CustomItem.getMaterial(nbtBlock.func_74779_i("Material")));
        this.field_149783_u = !this.func_176552_j();
        IBlockState iblockstate = this.field_176227_L.func_177621_b();
        if (!this.func_176552_j()) {
            iblockstate = iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        }
        this.func_180632_j(iblockstate.func_177226_a(VARIANT, (Comparable)((Object)CustomBlockTypes.TreeType.NORMAL)));
        this.nbtData = nbtBlock;
        this.field_149790_y = true;
        this.field_149762_H = SoundType.field_185851_d;
        this.field_149763_I = 1.0f;
        this.field_149786_r = this.field_149787_q ? 255 : 0;
        this.field_149785_s = !this.field_149764_J.func_76228_b();
        this.func_149711_c(0.0f);
        this.func_149752_b(10.0f);
        if (nbtBlock.func_150297_b("Hardness", 5)) {
            this.func_149711_c(nbtBlock.func_74760_g("Hardness"));
        }
        if (nbtBlock.func_150297_b("Resistance", 5)) {
            this.func_149752_b(nbtBlock.func_74760_g("Resistance"));
        }
        if (nbtBlock.func_150297_b("LightLevel", 5)) {
            this.func_149715_a(nbtBlock.func_74760_g("LightLevel"));
        }
        this.func_149672_a(CustomBlock.getNbtSoundType(nbtBlock.func_74779_i("SoundType")));
        this.func_149647_a(CustomRegisters.tabBlocks);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return this.func_176552_j() ? new BlockStateContainer((Block)this, new IProperty[]{VARIANT}) : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, VARIANT});
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return ((CustomBlockTypes.TreeType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    @Override
    public String getCustomName() {
        return this.nbtData.func_74779_i("RegistryName");
    }

    @Override
    public INbt getCustomNbt() {
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(this.nbtData);
    }

    @Nonnull
    public MapColor func_180659_g(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return ((CustomBlockTypes.TreeType)((Object)state.func_177229_b(VARIANT))).getMapColor();
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        int i = 0;
        i |= ((CustomBlockTypes.TreeType)((Object)state.func_177229_b(VARIANT))).ordinal();
        if (!this.func_176552_j() && state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return super.getPickBlock(state, target, world, pos, player);
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer) {
        if (this.func_176552_j()) {
            return this.func_176223_P();
        }
        IBlockState iblockstate = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        return facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? iblockstate : iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        try {
            iblockstate = iblockstate.func_177226_a(VARIANT, (Comparable)((Object)CustomBlockTypes.TreeType.values()[meta & CustomBlockTypes.TreeType.values().length]));
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        if (!this.func_176552_j()) {
            iblockstate = iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        }
        return iblockstate;
    }

    @Nonnull
    public Comparable<?> func_185674_a(@Nonnull ItemStack stack) {
        return CustomBlockTypes.TreeType.values()[stack.func_77952_i() & CustomBlockTypes.TreeType.values().length];
    }

    @Nonnull
    public String func_150002_b(int meta) {
        return this.func_149739_a() + ((CustomBlockTypes.TreeType)((Object)this.func_176203_a(meta).func_177229_b(VARIANT))).func_176610_l().toLowerCase();
    }

    @Nonnull
    public IProperty<?> func_176551_l() {
        return VARIANT;
    }

    @Override
    public int getType() {
        if (this.nbtData != null && this.nbtData.func_150297_b("BlockType", 1)) {
            return this.nbtData.func_74771_c("BlockType");
        }
        return 4;
    }

    public static class CustomBlockSlabSingle
    extends CustomBlockSlab {
        public CustomBlockSlabDouble doubleBlock;

        public CustomBlockSlabSingle(NBTTagCompound nbtBlock, CustomBlockSlabDouble addblock) {
            super(nbtBlock);
            String name = "custom_" + nbtBlock.func_74779_i("RegistryName");
            this.setRegistryName("customnpcs", name.toLowerCase());
            this.func_149663_c(name.toLowerCase());
            this.doubleBlock = addblock;
        }

        public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
            if (tab != CustomRegisters.tabBlocks && tab != CreativeTabs.field_78027_g) {
                return;
            }
            if (this.nbtData != null && this.nbtData.func_150297_b("ShowInCreative", 1) && !this.nbtData.func_74767_n("ShowInCreative")) {
                return;
            }
            items.add((Object)new ItemStack((Block)this, 1, 0));
            if (tab == CustomRegisters.tabBlocks) {
                Util.instance.sort(items);
            }
        }

        public boolean func_149710_n(@Nonnull IBlockState state) {
            return true;
        }

        public boolean func_176552_j() {
            return false;
        }
    }

    public static class CustomBlockSlabDouble
    extends CustomBlockSlab {
        public CustomBlockSlabSingle singleBlock;

        public CustomBlockSlabDouble(NBTTagCompound nbtBlock) {
            super(nbtBlock);
            String name = "custom_double_" + nbtBlock.func_74779_i("RegistryName");
            this.setRegistryName("customnpcs", name.toLowerCase());
            this.func_149663_c(name.toLowerCase());
        }

        public void func_149666_a(@Nonnull CreativeTabs itemIn, @Nonnull NonNullList<ItemStack> items) {
        }

        public boolean func_176552_j() {
            return true;
        }

        public void setSingle(CustomBlockSlabSingle block) {
            this.singleBlock = block;
        }
    }
}

